﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="../Project.master"
    CodeBehind="ProjectInAccordanceWithList.aspx.cs" Inherits="GUI.CodeTables.ProjectInAccordanceWithList"
    EnableEventValidation="false" %>
<%@ Register Src="~/Controls/CodeTablesNavigation.ascx" TagName="CodeTablesNavigation" TagPrefix="uc" %>
<%@ Register Src="~/Controls/LanguageBox.ascx" TagName="LanguageBox" TagPrefix="uc" %>
<asp:Content ID="Content1" ContentPlaceHolderID="FormPlaceHolder" runat="server">
        <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue kendo-form">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal5" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_ProjectAccordance %>" /> </span>
                        <span class="caption-helper"></span>
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="form-body">
                        <div class="row">
                            <div class="col-md-3 col-md-offset-9">
                                <uc:LanguageBox ID="LanguageBox" runat="server" Visible="true" />
                            </div>
                        </div>
    
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label">Id</label>
                                     <asp:TextBox CssClass="form-control" runat="server" ID="txtId" Enabled="False" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="ltr1" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Code %>" /></label>
                                     <asp:TextBox CssClass="form-control" runat="server" ID="txtCode" />
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Name %>" /></label>
                                    <asp:TextBox CssClass="form-control" runat="server" ValidationGroup="Validacija" ID="txtName" />
                                    <span class="help-block">  <asp:RequiredFieldValidator ID="txtNameRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic" CssClass="vError" SetFocusOnError="true"
														ControlToValidate="txtName" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" 
														ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator> </span>
                                </div>
                            </div>
                        </div>
                        <div class="form-actions right">
                             <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                            runat="server" />
                             <asp:Button ID="btnNew" OnClick="BtnNewClick" CssClass="btn blue" Text="<%$ Resources:ProjectManagementUI, Common_New %>" runat="server" />
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <telerik:RadGrid ID="grdProjectInAccordanceWithes" runat="server" OnItemCommand="GrdProjectPrioritiesItemCommand" Skin="Bootstrap">
					                <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>" ShowFooter="False" AutoGenerateColumns="False"
						                AllowCustomSorting="false" DataKeyNames="Id">
						                <Columns>
							                <telerik:GridBoundColumn UniqueName="IdColumn" HeaderText="Id" DataField="Id" />
							                <telerik:GridBoundColumn UniqueName="CodeColumn" SortExpression="Code" HeaderText="<%$ Resources:ProjectManagementUI, Common_Code %>"
								                DataField="Code" />
							                <telerik:GridBoundColumn UniqueName="NameColumn" SortExpression="Name" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>"
								                DataField="NameLocalized" />
							                <telerik:GridButtonColumn CommandName="Select" UniqueName="SelectColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm blue" HeaderText="" ButtonType="LinkButton"
								                Text="<%$ Resources:ProjectManagementUI, Common_Edit %>" />
							                <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%" ButtonCssClass="btn btn-sm red" HeaderText="" ButtonType="LinkButton"
								                Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>" ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>"/>
						                </Columns>
					                </MasterTableView>
				                </telerik:RadGrid>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:CodeTablesNavigation ID="CodeTablesNavigation" runat="server" />
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="InfoPlaceHolder" runat="server"></asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="TitlePlaceHolder" runat="server"></asp:Content>